/*----------------------------------------------------------------------------
 * Name:    led.c
 * Purpose:
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/
#include	"led.h"

uc32	LEDMask[MAX_LED_NUM] = { LED1_IO,LED2_IO,LED3_IO,LED4_IO,LEDP_IO };
u16	LEDFlashTimer[MAX_LED_NUM];
u16	LEDFlashTmCnt[MAX_LED_NUM];

/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_IO_configure(void)
{

   /* configure LED as GPIO  */
   AFIO_GPxConfig(LED_AFIO_PORT,
						LED1_IO | LED2_IO | LED3_IO | LED4_IO | LEDP_IO,
						AFIO_FUN_GPIO);
   /* configure LED as OUT mode  */
   GPIO_DirectionConfig(LED_PORT,
						LED1_IO | LED2_IO | LED3_IO | LED4_IO | LEDP_IO,
						GPIO_DIR_OUT);
   /* configure LED1 driving current = 12mA  */
   GPIO_DriveConfig(LED_PORT,
						LED1_IO | LED2_IO | LED3_IO | LED4_IO | LEDP_IO,
						GPIO_DV_16MA);
	LED1_OFF();
	LED2_OFF();
	LED3_OFF();
	LED4_OFF();
	LEDP_OFF();
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_always_on(u8 led)
{
	u8	x,m;

	m = LED1;
	for(x=0;x<MAX_LED_NUM;x++)
	{
		if(led & m)
		{
			LEDFlashTimer[x] = 0;
			LED_PORT->RR = LEDMask[x];
		}
		m <<= 1;
	}
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_always_off(u8 led)
{
	u8	x,m;

	m = LED1;
	for(x=0;x<MAX_LED_NUM;x++)
	{
		if(led & m)
		{
			LEDFlashTimer[x] = 0;
			LED_PORT->SRR = LEDMask[x];
		}
		m <<= 1;
	}
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_flash_enable(u8 led,u16 timer)
{
	u8	x,m;

	m = LED1;
	for(x=0;x<MAX_LED_NUM;x++)
	{
		if(led & m)
		{
			LEDFlashTimer[x] = timer;
			LED_PORT->RR = LEDMask[x];
		}
		m <<= 1;
	}
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_flash_process(void)
{
	u8	x;

	for(x=0;x<MAX_LED_NUM;x++)
	{
		if(LEDFlashTimer[x])
		{
			if(--LEDFlashTmCnt[x] == 0)
			{
				LEDFlashTmCnt[x] = LEDFlashTimer[x];
				if(LED_PORT->DOUTR & LEDMask[x])
					LED_PORT->RR = LEDMask[x];			//LED ON
				else
					LED_PORT->SRR = LEDMask[x];		//LED OFF
			}
		}
	}
}
